import math

substitution_map = {0:14,1:4,2:13,3:1,4:2,5:15,6:11,7:8,8:3,9:10,10:6,11:12,12:5,13:9,14:0,15:7}

key = [3,10,9,4,13,6,3,15]				# Key
# key = [8,9,10,12,3,6,11,5]
key_length = len(key) * 4				# Calculate length of the key in bits
bytes_per_key = key_length / 8			# Calculate the number of bytes for each round key (4 for a 32-bit key)
rounds = int(math.log(key_length,2))	# Calculate the number of rounds (5 for a 32-bit key)

# plaintext = [2,6,11,7]
# plaintext = [15,14,2,6]
# plaintext = [15,14,2,7]
plaintext = [2,13,0,0]

def get_key(key, round):
	'''Returns the round key for the specified key.
	The round key is bytes_per_key bytes starting at the specified offset determined by round.'''
	round -= 1
	ret = []
	for index in range(bytes_per_key):
		ret.append(key[index + round])
	return ret

def xor_array(array, key):
	'''Xor the two arrays and returns the result.'''
	ret = []
	for index in range(len(array)):
		ret.append(array[index] ^ key[index])
	return ret

def sub_array(array):
	'''Runs the given array through the substitution map and returns the result.'''
	ret = []
	for index in range(len(array)):
		ret.append(substitution_map[array[index]])
	return ret

def perm_array(array):
	'''Permutes the given array and returns the results.'''
	ret = []
	for index in range(bytes_per_key-1,-1,-1):
		value = 0
		for entry in array:
			value <<= 1
			value |= (entry >> index) & 1
		ret.append(value)
	return ret

if __name__ == '__main__':
	working_array = plaintext 	# Initial array is the plaintext
	print "Round 0 W (Plaintext):\t", plaintext
	print

	# Print out the results for each step as it is calculated
	for round in range(1,rounds-1):
		print "Round {0} Key:\t\t\t".format(round),get_key(key, round)
		working_array = xor_array(working_array, get_key(key, round))
		print "Round {0} U (xor'ed):\t\t".format(round),working_array
		working_array = sub_array(working_array)
		print "Round {0} V (sub'ed):\t\t".format(round),working_array
		working_array = perm_array(working_array)
		print "Round {0} W (perm'ed):\t".format(round),working_array
		print

	# Calculate and print out the final round without the permutation
	print "Round {0} Key:\t\t\t".format(rounds-1),get_key(key, rounds-1)
	working_array = xor_array(working_array, get_key(key, rounds-1))
	print "Round {0} U (xor'ed):\t\t".format(rounds-1),working_array
	working_array = sub_array(working_array)
	print "Round {0} V (sub'ed):\t\t".format(rounds-1),working_array
	print
	print "Round {0} Key:\t\t\t".format(rounds),get_key(key, rounds)
	working_array = xor_array(working_array, get_key(key,rounds))
	print("Ciphertext (xor'ed):\t"), working_array
